#include "MTSUBTViewer.h"
#include "MTFileList.h"
#include "MTUtilities.h"
#include "IDataStream.h"
#include "MTExceptions.h"

MTInfoWindowDataTemplate	MTSUBTViewer::kSUBTTemplate =
{
	3,
	{
		{	"ID" },
		{	"Version" },
		{	"Source Offset" }
	}
};

struct MTSUBTFormat
{
	UInt32	id;
	UInt32	version;
	UInt16	filler1[8];
	UInt32	sourceFile;
	UInt32	numEntries;
	UInt32	entries[0];
};

void MTSUBTViewer::ParseData(UInt8 * buf, UInt32 bufSize)
{
	MTSUBTFormat	* format;
	char			text[256];
	
	if(bufSize < sizeof(MTSUBTFormat))
		throw MTUnsupportedException("Unsupported data structure");
	
	format = (MTSUBTFormat *)buf;
	
	SWAP32(format->id);
	SWAP32(format->version);
	SWAP32(format->sourceFile);
	SWAP32(format->numEntries);
	
	for(UInt32 i = 0; i < format->numEntries; i++)
	{
		SWAP32(format->entries[i]);
	}
	
	id =			format->id;
	version =		format->version;
	sourceFile =	format->sourceFile;
	
	entries.resize(format->numEntries);
	for(UInt32 i = 0; i < format->numEntries; i++)
	{
		entries[i].offset = format->entries[i];
	}
	
	AttachDataTemplate(&kSUBTTemplate);
	
	SetNumEntries(3 + (format->numEntries * 2));
	
	std::sprintf(text, "%.8X", id);
	SetEntryData(0, text, 0);
	
	std::sprintf(text, "%.8X", version);
	SetEntryData(1, text, 0);
	
	std::sprintf(text, "%.8X", sourceFile);
	SetEntryData(2, text, 0);
	
	MTFileList * fileList = GetOwningFileList();
	IFileStream	* stream = fileList->theFile->OpenRawFile();
	
	for(UInt32 i = 0; i < format->numEntries; i++)
	{
		stream->SetPosition(sourceFile + entries[i].offset);
		stream->ReadString(text, 256);
		
		entries[i].title = text;
		
		stream->ReadString(text, 256);
		
		entries[i].data = text;
		
		SetEntryData(3 + (i * 2), entries[i].title.c_str(), 0);
		SetEntryTitle(3 + (i * 2), "Title", 0);
		
		SetEntryData(4 + (i * 2), entries[i].data.c_str(), 0);
		SetEntryTitle(4 + (i * 2), "Message", 0);
	}
	
	stream->CloseFile();
	
	delete stream;
	
	SetOwnerName("SUBT");
	
	DisposePtr((Ptr)buf);
}